#ifndef __DM_SPI_FLASH_H__
#define __DM_SPI_FLASH_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

enum
{
  FLASH_M25P10,      // m25p10 or compatiblie type eeprom
  FLASH_M25P20,      // m25p20 or compatiblie type eeprom
  FLASH_SST25LF040A, // st25lf040 type eeprom
  FLASH_SST25VF040B, // st25vf040b type eeprom
  FLASH_SST25VF016B, // st25vf016b type eeprom
  FLASH_M25P16,      // m25p16 type eeprom
  FLASH_M25P32,      // m25p32 or compatiblie type eeprom
  FLASH_M25P40,      // m25p40 or compatibile type eeprom
  FLASH_M25P128,     // m25p128 or compatibile type eeprom
  FLASH_OTHER
};

enum
{
    SPI_DSP_FLASH,
    SPI_FPGA_FLASH,
    SPI_DSP,
    SPI_VALENS,
    SPI_SECOND_FPGA_FLASH,
    SPI_VALENS2,
    SPI_OSD_FLASH,
    SPI_VALENS3,
    SPI_VALENS4,
    SPI_VALENS5,
    SPI_VALENS_RX1,
    SPI_VALENS_RX2,
    SPI_SECOND_DSP_FLASH,
    SPI_SIL9575_FLASH,
    SPI_EXTERNAL_NVL_FLASH,
    MAX_DM_SPI_FLASH_DEVICES
};

#define FLASH_SIZE_MAX  0xFFFFFFFF
#define M25P40_SIZE_MAX 0x0007ffff
#define M25P16_SIZE_MAX 0x0001FFFFF
#define SST25LF040A     0x44 //ID
#define SST25VF040B     0x8D //ID
#define SST25VF016B     0x41 //ID
#define SST25VF032B     0x4A //ID

#ifdef __cplusplus
extern "C" {
#endif

extern INT32  SerialFlashWriteBlock(UINT32 inst, UINT32 addr, UINT8 * pSrc, UINT32 byteCnt);
extern INT32  SerialFlashReadBlock(UINT32 inst, UINT32 addr, UINT8 * pDest, UINT32 byteCnt);
extern INT32  SerialFlashEraseBlock(UINT32 inst, UINT32 addr, UINT32 byteCnt);
extern UINT32 SerialFlashGetId(UINT32 inst);
extern UINT32 SerialFlashGetBytes(UINT32 inst);
extern UINT32 SerialFlashGetSectorBytes(UINT32 inst);
extern UINT32 SerialFlashGetPageBytes(UINT32 inst);
extern INT32  SerialFlashGetBusAndAddr(UINT32 inst, UINT32 * pBus, UINT32 * pAddr, UINT32 * pFlash);
extern UINT8  SerialFlashReadRDSR(UINT32 spiBus, UINT32 spiAddr);

extern INT32 SerialFlashReadBlock_DMA(UINT32 inst, UINT32 addr, UINT8 * pBuffer,
                           UINT32 byteCnt,UINT32 Timeout);

#ifdef __cplusplus
}
#endif

#endif  //__DM_SPI_FLASH_H__

